/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.config;

import com.gitlab.srcmc.rctmod.api.config.IClientConfig;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ClientConfig
implements IClientConfig {
    private ModConfigSpec.ConfigValue<Boolean> showTrainerTypeSymbolsValue;
    private ModConfigSpec.ConfigValue<Boolean> showTrainerTypeColorsValue;
    private boolean showTrainerTypeSymbolsCached;
    private boolean showTrainerTypeColorsCached;
    private ModConfigSpec.ConfigValue<Integer> trainerCardPaddingValue;
    private ModConfigSpec.ConfigValue<Double> trainerCardAlignmentXValue;
    private ModConfigSpec.ConfigValue<Double> trainerCardAlignmentYValue;
    private int trainerCardPaddingCached;
    private float trainerCardAlignmentXCached;
    private float trainerCardAlignmentYCached;
    private ModConfigSpec spec;

    public ClientConfig() {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        builder.push("Trainers");
        this.showTrainerTypeSymbolsValue = builder.comment(new String[]{"\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", "Determines if symbols for trainer types are shown next to trainer names."}).define("showTrainerTypeSymbols", IClientConfig.super.showTrainerTypeSymbols());
        this.showTrainerTypeColorsValue = builder.comment(new String[]{"\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", "Determines if trainer names are colored based of their type."}).define("showTrainerTypeColors", IClientConfig.super.showTrainerTypeColors());
        builder.pop();
        builder.push("Trainer Card");
        this.trainerCardPaddingValue = builder.comment(new String[]{"\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", "Padding of the trainer card gui."}).defineInRange("trainerCardPadding", IClientConfig.super.trainerCardPadding(), 0, 0x7FFFFFFE);
        this.trainerCardAlignmentXValue = builder.comment(new String[]{"\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", "Horizontal alignment of the trainer card gui, i.e. 0=left, 0.5=center, 1=right."}).defineInRange("trainerCardAlignmentX", (double)IClientConfig.super.trainerCardAlignmentX(), 0.0, 1.0);
        this.trainerCardAlignmentYValue = builder.comment(new String[]{"\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", "Vertical alignment of the trainer card gui, i.e. 0=top, 0.5=center, 1=bottom."}).defineInRange("trainerCardAlignmentY", (double)IClientConfig.super.trainerCardAlignmentY(), 0.0, 1.0);
        this.spec = builder.build();
    }

    @Override
    public void reload() {
        this.updateCache();
    }

    private void updateCache() {
        this.showTrainerTypeSymbolsCached = (Boolean)this.showTrainerTypeSymbolsValue.get();
        this.showTrainerTypeColorsCached = (Boolean)this.showTrainerTypeColorsValue.get();
        this.trainerCardPaddingCached = (Integer)this.trainerCardPaddingValue.get();
        this.trainerCardAlignmentXCached = ((Double)this.trainerCardAlignmentXValue.get()).floatValue();
        this.trainerCardAlignmentYCached = ((Double)this.trainerCardAlignmentYValue.get()).floatValue();
    }

    @Override
    public ModConfigSpec getSpec() {
        return this.spec;
    }

    @Override
    public boolean showTrainerTypeSymbols() {
        return this.showTrainerTypeSymbolsCached;
    }

    @Override
    public boolean showTrainerTypeColors() {
        return this.showTrainerTypeColorsCached;
    }

    @Override
    public int trainerCardPadding() {
        return this.trainerCardPaddingCached;
    }

    @Override
    public float trainerCardAlignmentX() {
        return this.trainerCardAlignmentXCached;
    }

    @Override
    public float trainerCardAlignmentY() {
        return this.trainerCardAlignmentYCached;
    }
}

